#***************************************************************
#SimLab Version 2020.1 Beta
#Created at Thu Jul 23 19:49:55 2020
#***************************************************************
#For debugging this python script,Please comment(#) out the line "from hwx import simlab" and uncomment the line "import simlab"
from hwx import simlab
#import simlab


UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

# ImportSlb=''' <ImportSlb CheckBox="ON" gda="" UUID="C806F6DF-56FA-4134-9AD1-1010BF292183">
#   <tag Value="1"/>
#   <Name Value="./2D_Brushless_Permanent_Magnet_Motor_Sketch.slb"/>
#   <FileName Value="./2D_Brushless_Permanent_Magnet_Motor_Sketch.slb"/>
#   <ImportOrOpen Value="1"/>
#   <Output/>
#  </ImportSlb>''';
# simlab.execute(ImportSlb);

SketchImport=''' <SketchImport UUID="0a77ff81-ad78-4874-aa7a-5027973b6b63">
  <FileName Value="./2D_Brushless_Permanent_Magnet_Motor_Sketch.skt"/>
 </SketchImport>''';
simlab.execute(SketchImport);

# ModifyParameters=''' <ModifyParameters UUID="4ca68ace-4163-416c-9a28-bceae4fccad9">
  # <Parameter Type="0" Value="35" OldName="STATOR_SLOT_DEPTH"/>
  # <Parameter Type="0" Value="4" OldName="MAGNET_THICKNESS"/>
 # </ModifyParameters>''';
# simlab.execute(ModifyParameters);

RealizeSketch=''' <RealizeSketch UUID="dab4b0dc-490c-444b-96d0-51790465e4d6">
  <SketchName Value="Wedge,Rotating_Air_Gap,Coil,Shaft,Rotor,Magnet,Rotor_Air,Stator,"/>
 </RealizeSketch>''';
simlab.execute(RealizeSketch);

Mirroring=''' <Mirroring gda="" CheckBox="ON" UUID="67e16ad8-f140-4976-b9f7-e9c4f9e7005b">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Wedge","Coil","Stator",</Body>
   </Entities>
  </SupportEntities>
  <PlanePoints>
   <RegionObject>
    <Plane>
     <Finite Value="0"/>
     <Pt1 Value="-1.83318 mm,-0.120153 mm,-1.83712 mm,"/>
     <Pt2 Value="-1.83318 mm,-0.120153 mm,1.83712 mm,"/>
     <Pt3 Value="1.83318 mm,0.120153 mm,1.83712 mm,"/>
     <Pt4 Value="1.83318 mm,0.120153 mm,-1.83712 mm,"/>
    </Plane>
   </RegionObject>
  </PlanePoints>
  <Copy Value="1"/>
  <WithLBC Value="0"/>
  <LocalCoordinateSystem Value=""/>
  <Output/>
 </Mirroring>''';
simlab.execute(Mirroring);

Mirroring=''' <Mirroring gda="" CheckBox="ON" UUID="67e16ad8-f140-4976-b9f7-e9c4f9e7005b">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Shaft","Rotor","Rotor_Air","Rotating_Air_Gap","Magnet",</Body>
   </Entities>
  </SupportEntities>
  <PlanePoints>
   <RegionObject>
    <Plane>
     <Finite Value="0"/>
     <Pt1 Value="-6.0994 mm,-2.52645 mm,-77.1019 mm,"/>
     <Pt2 Value="-6.0994 mm,-2.52645 mm,77.1019 mm,"/>
     <Pt3 Value="136.366 mm,56.4848 mm,77.1019 mm,"/>
     <Pt4 Value="136.366 mm,56.4848 mm,-77.1019 mm,"/>
    </Plane>
   </RegionObject>
  </PlanePoints>
  <Copy Value="1"/>
  <WithLBC Value="0"/>
  <LocalCoordinateSystem Value=""/>
  <Output/>
 </Mirroring>''';
simlab.execute(Mirroring);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Stator","Stator",</Body>
    <BodyIndex>11,1,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Coil","Coil",</Body>
    <BodyIndex>6,10,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Wedge","Wedge",</Body>
    <BodyIndex>9,8,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Rotor","Rotor",</Body>
    <BodyIndex>4,13,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Shaft","Shaft",</Body>
    <BodyIndex>12,5,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Rotor_Air","Rotor_Air",</Body>
    <BodyIndex>14,2,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Boolean=''' <Boolean UUID="83ff924f-a248-479c-b159-f6266f6d6db7">
  <InputOption Value="CAD(Parasolid)"/>
  <Operation Value="Combine"/>
  <InputBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Rotating_Air_Gap","Rotating_Air_Gap",</Body>
    <BodyIndex>15,7,</BodyIndex>
   </Entities>
  </InputBodies>
  <CreateConnectedBodies Value="0"/>
 </Boolean>''';
simlab.execute(Boolean);

Rotation=''' <Rotation gda="" CheckBox="ON" UUID="46af1a6e-103c-4803-9846-7e0579bc1dd9">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Stator","Coil","Wedge",</Body>
   </Entities>
  </SupportEntities>
  <Axis Value="Z"/>
  <Center Value="0 mm, 0 mm, 0 mm"/>
  <AxisDirection>
   <RegionObject>
    <Axis>
     <Pt1 Value="0 mm,0 mm,-15.5462 mm,"/>
     <Pt2 Value="0 mm,0 mm,15.5462 mm,"/>
    </Axis>
   </RegionObject>
  </AxisDirection>
  <Angle Value="7.5 deg"/>
  <Pattern Value="1"/>
  <WithLBC Value="0"/>
  <No.Of.Instance Value="5"/>
  <Tolerance Value="0.001 mm"/>
  <Merge Value="0"/>
  <LocalCoordinateSystem Value=""/>
  <Output/>
 </Rotation>''';
simlab.execute(Rotation);

SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Shaft","Rotor","Magnet","Magnet","Rotor_Air_2","Rotor_Air_3","Rotor_Air_1",</Body>
    <BodyIndex>21,20,3,16,24,25,23,</BodyIndex>
   </Entities>
  </InputBody>
  <Option Value="Faces"/>
  <Groupname Value="Rotor_Faces"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Rotor_Air","Rotating_Air_Gap",</Body>
   </Entities>
  </InputBody>
  <Option Value="Faces"/>
  <Groupname Value="Air_Region"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>$Geometry</Model>
    <Body>"Stator","Stator","Coil","Wedge","Coil","Wedge","Stator","Coil","Wedge","Stator","Coil","Wedge","Stator","Coil","Wedge","Coil","Wedge","Stator",</Body>
    <BodyIndex>36,39,40,41,37,38,33,34,35,30,31,32,27,28,29,18,19,17,</BodyIndex>
   </Entities>
  </InputBody>
  <Option Value="Faces"/>
  <Groupname Value="Stator_Faces"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

MotorMesh=''' <MotorMesh UUID="74b59b93-5dcc-4502-a523-e59abc2f1a8b">
  <tag Value="-1"/>
  <StatorFaces>
   <Group>"Stator_Faces",</Group>
  </StatorFaces>
  <StatorPeriodicity Value="6"/>
  <StatorMirror Checked="1"/>
  <AirRegionFaces>
   <Group>"Air_Region",</Group>
  </AirRegionFaces>
  <AirRegionMeshSize Value="0.6 mm"/>
  <RotorFaces>
   <Group>"Rotor_Faces",</Group>
  </RotorFaces>
  <RototPeriodicity Value="1"/>
  <RotorMirror Checked="1"/>
  <MeshSize Value="3 mm"/>
  <ExtrudeLength Value="0 mm"/>
  <ExtrudeLayers Value="1"/>
 </MotorMesh>''';
simlab.execute(MotorMesh);


ExportSlb=''' <ExportSlb UUID="a155cd6e-8ae6-4720-8ab4-1f50d4a34d1c">
  <tag Value="-1"/>
  <Name Value=""/>
  <Option Value="0"/>
  <Duplicate Value="0"/>
  <FileName Value="./2D_Motor_Mesh_Output.slb"/>
 </ExportSlb>''';
simlab.execute(ExportSlb);
